; baktracer
; verbosity
; verbose (various functions)
; debug (various functions)

(defun baktracer (&optional terse)
"Args: &optional terse
BacTrace Manager. Shows function name at each level. Commands are:
\n+ go to next baktrace level                q quit baktracer
\n- go back to previous baktrace level       h help about baktracer
\n> more details about this baktrace level   v verbose baktracer mode switch"
  (let ((i 0)
        (str "; Commands: + next      - previous  > more detail")
        (str2";           h help      q quit      v verbose\n"))
    (format t "~a~%~a~%" str str2)
    (loop
       (if (= i 0)
           (format t "top level > ")
           (format t "level ~d   > "i))
       (setf x (read ))
       (case x
         ('+ (setf i (1+ i)) (baktrace i nil))
         ('q (return))
         ('- (setf i (1- i)) (if (= i 0) (return) (baktrace i nil)))
         ('h (help 'baktracer))
         ('> (baktrace i ))
         ('v (setf *baktracer-verbose* (not *baktracer-verbose*))
             (when *baktracer-verbose* (format nil "~a" str)))
         ))))


(defun ini-debug (&optional (mode *debug-mode*))
"Args: (&optional (mode *debug-mode*))
Sets the INI debug mode variable to on or off according to value of MODE. Does not modify system states. Returns T or NIL indicating debug mode."
  (let ((d-yesno (if mode "Yes" "No")))
    (msw-write-profile-string 
     "ViSta" "Debug" d-yesno (strcat *default-path* "wxls32.ini"))
    mode))


(defun ini-verbose (&optional (mode *verbose*))
"Args: (&optional (mode *verbose*))
Sets the INI verbose mode variables to on or off according to value of MODE. Does not modify system states. Returns T or NIL indicating verbose mode."
  (let ((v-yesno (if mode "Yes" "No")))
    (msw-write-profile-string 
     "ViSta" "LoadVerbose" v-yesno (strcat *default-path* "wxls32.ini"))
    (msw-write-profile-string 
     "ViSta" "Verbose" v-yesno (strcat *default-path* "wxls32.ini"))
    (msw-write-profile-string 
     "ViSta" "StartupVerbose" v-yesno (strcat *default-path* "wxls32.ini"))
    mode))

(defun ini-load-verbose (&optional (mode *debug-mode*))
"Args: (&optional (mode *debug-mode*))
Sets the INI load-verbose mode variable to on or off according to value of MODE. Does not modify system states. Returns T or NIL indicating verbose mode."
  (let ((v-yesno (if mode "Yes" "No")))
    (msw-write-profile-string 
     "ViSta" "LoadVerbose" v-yesno (strcat *default-path* "wxls32.ini"))
    mode))

(defun ini-startup-verbose (&optional (mode *startup-verbose*))
"Args: (&optional (mode  *startup-verbose*))
Sets the INI startup-verbose mode variable to on or off according to value of MODE. Does not modify system states. Returns T or NIL indicating verbose mode."
  (let ((v-yesno (if mode "Yes" "No")))
    (msw-write-profile-string 
     "ViSta" "StartupVerbose" v-yesno (strcat *default-path* "wxls32.ini"))
    mode))

(defun ini-log (&optional (mode nil))
"Args: (&optional (mode *debug-mode*))
Sets the INI log mode variable to on or off according to value of MODE. Does not modify system states. Returns T or NIL indicating log mode."
  (let ((l-yesno (if mode "Yes" "No")))
    (msw-write-profile-string 
     "ViSta" "Log" l-yesno (strcat *default-path* "wxls32.ini"))
    mode))

  
(setf *verbose-file-open* nil)

(defun verbose (&optional (logical nil l-set) (file-name nil set));was (file-name nil set)
"Args: (logical &optional (file-name nil set))
Reports value of *verbose*. If LOGICAL is used, turns verbose mode on or off depending on value of LOGICAL. Verbose mode sets the variables *v* *verbose* *search-verbose* *load-verbose* *file-verbose* *visible-startup* and *container-verbose*. 
  FILE-NAME ignored if LOGICAL is nil. Otherwise: If FILE-NAME is not used, creates no file. If FILE-NAME is t, creates file lognnnn.log, where nnnn is the next log number. If FILE-NAME is a string, creates file FILE-NAME. Thus
(verbose t) turns verbose mode on and creates no file
(verbose nil) turns verbose mode off
(verbose t \"build.log\" turns verbose mode on and creates file build.log
(verbose t t) turns verbose mode on and creates file lognnnn.log"
  (cond
    ((not l-set) 
     (format t "; verbose mode is ~d~%" (if *verbose* "on" "off"))
     *verbose*)
    (logical
     #|
     (unless *make-time*
             (when *verbose* ;fwy added clause 09-20-02
                   (format t "; verbose mode ~a on~%" (if *verbose* "remains" "turned")))
             (if *verbose-file-open*
                 (format t "; logfile ~a is open~%" *verbose-file-open*)
                 (when (not set)
                       (format t "; logfile not opened. to open, type (verbose t t)~%"))
                 )
             )
     |#
     (cond
       (*make-time*); ((not *vista*))
       ((or file-name (stringp file-name)) 
        (cond
          ((and *verbose-file-open* (not (stringp file-name)))
           (format t "; logfile remains open~%"))
          
          (t
           (when *verbose-file-open* 
                 (format t "; currently open verbose file will be closed.")
                 (double-dribble))
           (set-working-directory *default-path*)
           (unless (stringp file-name) (setf file-name (get-next-log-filename)))
           (double-dribble file-name)
           (make-vista-copyright)
           (copyright)
           (setf *verbose-file-open* file-name)
           (format t "~2%; opened logfile ~a~a~%" *default-path* file-name)
           (format t "; opened logfile on ~a, at ~a. Opened by (verbose t t)~2%" 
                   (first (date-time)) (second (date-time)))))))
     (setf *v* t)
     (setf *verbose* t)
     (setf *search-verbose* t)
     (setf *load-verbose* t)
     (setf *file-verbose* t)
     (setf *log-verbose* t)
     #|
     (format t "; these verbose flags were placed on:~%;     *v*, *verbose*, *search-verbose*, *log-verbose*, *load-verbose*, *file-verbose*~%; these verbose flags were unchanged:~%;     *container-verbose* (NIL), *baktracer-verbose* (T), *search-verbose* (~a),~%;     *statinit-verbose* (~a), *xlispverbose* (~a)~%" *container-verbose* *baktracer-verbose* *search-verbose* *statinit-verbose*  *xlispverbose*)
     |#
     )
    (t
     (unless *make-time* 
             (when *verbose* (format t "; verbose mode ~a off~%" ;fwy added clause -9-20-02
                     (if *verbose*  "turned" "remains"))))
     (cond
       ((not *verbose*));asked to turn off and is already off
       (t ;asked to turn off and when it is on
          (when *verbose-file-open* 
                (let* ((now-file-name *verbose-file-open*)
                       ; (strcat *default-path* "log" 
                       ;         (format nil "~a" *log-number*) ".log")
                       )
                  (if (probe-file now-file-name)
                      (progn    
                       (double-dribble) ;closes drible file
                       (setf *verbose-file-open* nil)
                       (format t "; closed  ~a~%" now-file-name))
                      (unless *make-time* 
                              (format t "; could not find ~a~%" now-file-name)))))))
     (setf *v* nil)
     (setf *verbose* nil)
     (setf *search-verbose* nil)
     (setf *load-verbose* nil)
     (double-dribble)
     (setf *log-verbose* nil)
     ))

  (when (not *make-time*)
        (write-verbose-file)
        (ini-verbose *verbose*)
        (when *vista* (ignore-errors (send verbose-item :mark *verbose*)))
        )
     
  (setf *file-verbose* *verbose*)
  (ini-load-verbose *load-verbose*)
  (msw-write-profile-string 
   "ViSta" "Verbosity" (format nil "~a" *verbosity*) (strcat *default-path* "wxls32.ini"))
  *verbose*)
  

(defun terse ()
"Turns verbose mode off"
  (verbose nil))

(defun verbose-toggle ()
  (cond 
    (*verbose*
     (verbose nil)
     (ignore-errors (send verbose-item :mark nil))
     (clean-up)
    ; (top-level nil)
     )
    (t
     (verbose t)
     (ignore-errors (send verbose-item :mark t))
     (clean-up)
    ; (top-level nil)
    ))
  (format t "; verbose toggle:  *verbose* set to ~d~%" *verbose*)
  )

(defun verbose-mode (&optional (logical nil set))
  (when set (setf *verbose* (not logical)))
  (format t "; verbose mode:    *verbose* set to ~d~%" *verbose*)
  (verbose-toggle))

(defun file-verbose (&optional (logical nil l-set) (file-name nil set));was (file-name nil set)
"Args: (logical &optional (file-name nil set))
Reports value of *file-verbose*. If LOGICAL is used, turns file-verbose mode on or off depending on value of LOGICAL. file-Verbose mode sets the variables *file-verbose* and *load-verbose*. See (verbose) for a more general function. 
  FILE-NAME ignored if LOGICAL is nil. Otherwise: If FILE-NAME is not used, creates no file. If FILE-NAME is t, creates file lognnnn.log, where nnnn is the next log number. If FILE-NAME is a string, creates file FILE-NAME. Thus
(file-verbose t)   turns file-verbose mode on and creates no file
(file-verbose nil) turns file-verbose mode off
(file-verbose t   \"build.log\" turns file-verbose mode on and creates file build.log
(file-verbose t t) turns file-verbose mode on and creates file lognnnn.log"
  (cond
    ((not l-set) 
     (format t "; file-verbose mode is ~d~%" (if *file-verbose* "on" "off"))
     *file-verbose*)
    (logical
     (unless *make-time*
             (format t "; file-verbose mode ~a on~%" (if *file-verbose* "remains" "turned"))
             (if *file-verbose-file-open*
                 (format t "; logfile ~a is open~%" *file-verbose-file-open*)
                 (when (not set)
                       (format t "; logfile not opened. to open, type (verbose t t)~%"))))
     (cond
       (*make-time*); ((not *vista*))
       ((or file-name (stringp file-name)) 
        (cond
          ((and *file-verbose-file-open* (not (stringp file-name)))
           (format t "; logfile remains open~%"))
          
          (t
           (when *file-verbose-file-open* 
                 (format t "; currently open file-verbose file will be closed.")
                 (double-dribble))
           (set-working-directory *default-path*)
           (unless (stringp file-name) (setf file-name (get-next-log-filename)))
           (double-dribble file-name)
           (make-vista-copyright)
           (copyright)
           (setf *file-verbose-file-open* file-name)
           (format t "~2%; opened logfile ~a~a~%" *default-path* file-name)
           (format t "; opened logfile on ~a, at ~a. Opened by (file-verbose t t)~2%" 
                   (first (date-time)) (second (date-time)))))))
     (setf *load-verbose* t)
     (setf *file-verbose* t)
     (format t "; *file-verbose* ~a~%; *load-verbose* ~a~%" *file-verbose* *load-verbose*))
    (t
     (unless *make-time* 
             (format t "; file-verbose mode ~a off~%"
                     (if *file-verbose*  "turned" "remains")))
     (cond
       ((not *file-verbose*));asked to turn off and is already off
       (t ;asked to turn off and when it is on
          (when *file-verbose-file-open* 
                (let* ((now-file-name *file-verbose-file-open*)
                       ; (strcat *default-path* "log" 
                       ;         (format nil "~a" *log-number*) ".log")
                       )
                  (if (probe-file now-file-name)
                      (progn    
                       (double-dribble) ;closes drible file
                       (setf *file-verbose-file-open* nil)
                       (format t "; closed  ~a~%" now-file-name))
                      (unless *make-time* 
                              (format t "; could not find ~a~%" now-file-name)))))))
     (setf *file-verbose* nil)
     (setf *load-verbose* nil)
     (double-dribble)
     ))

  (when (not *make-time*)
        (write-verbose-file)
        (ini-load-verbose *load-verbose*)
        (when *vista* (ignore-errors (send verbose-item :mark *verbose*)))
        )
  *file-verbose*)
  
(setf *verbosity* 0)



(defun verbosity-toggle ()
  (cond 
    ((> *verbosity* 0)
     (verbosity 0)
     (ignore-errors (send verbose-item :mark nil))
     (clean-up)
    ; (top-level nil)
     )
    (t
     (verbosity 4)
     (ignore-errors (send verbose-item :mark t))
     (clean-up)
    ; (top-level nil)
    ))
  (format t "; verbose toggle:  *verbose* set to ~d~%" *verbose*)
  )

(defun verbosity (&optional level &key (log nil) (visible nil visible?))
"Args: Level text nil) report verbosity level
0 = Silent  no printout
1 = Dialog, StartUp Verbose
2 = Listener, Dialog, StartUp and File Verbose
3 = Logging, Listener, Dialog, StartUp and File Verbose
4 = Debugging, Logging, Listener, Dialog, StartUp and File Verbose"

  (if visible 
      (listeners) 
      (when visible? 
            (unless *hide-xlispstat* (hidemainwindow))
            (send *listener* :hide-window)))
  (cond
    ((not level))
    ((= level 0)
     (double-dribble) ; closes open log file,if there is one
     (debug-mode nil) 
     (verbose nil)
     (setf *startup-verbose* nil)
     (setf *file-verbose* nil)
     (setf *load-verbose* nil)
     (save-the-environment)
     (unless *hide-xlispstat* (hidemainwindow))
     (msw-write-profile-string 
      "ViSta" "DeBugLog" "No" (strcat *default-path* "wxls32.ini"))
     (msw-write-profile-string 
      "ViSta" "LoadVerbose" "No" (strcat *default-path* "wxls32.ini"))
     (msw-write-profile-string 
      "ViSta" "StartUpVerbose" "No" (strcat *default-path* "wxls32.ini"))
     (msw-write-profile-string 
      "ViSta" "Verbose" "No" (strcat *default-path* "wxls32.ini"))
     (msw-write-profile-string 
      "XLisp" "HideMainFrame" "Yes" (strcat *default-path* "wxls32.ini"))
     (setf *verbosity* 0)
     )
    (t
     (format t "~%; *verbosity* = ~a (~a)~%"
             level
             (case level
               (0 "Silent")
               (1 "Dialog, StartUp Verbose")
               (2 "Listener, Dialog, StartUp and File Verbose")
               (3 "Logging, Listener, Dialog, StartUp and File Verbose ")
               (4 "Debugging, Logging, Listener, Dialog, StartUp and File Verbose")))
    ; (format t "; 1) Startup Verbose on.~%")
     (when log 
           (msw-write-profile-string 
            "ViSta" "DeBugLog" "Yes" (strcat *default-path* "wxls32.ini"))
           (setf *log-verbose* t)
           (setf *log-number* (1+ *log-number*))
           (double-dribble (format nil "wks~a.log" *log-number*))
           (xls-copyright) 
           (xls-mod-copyright) 
           (format t "~%~a" *xls-copyright*)
           (format t "~%~a" *xls-mod-copyright*)
           (vista-copyright *run-number* 3))
     (when (= level 1) 
           (setf *startup-verbose* t)
           (setf *verbosity* 1)
           (msw-write-profile-string 
            "XLisp" "HideMainFrame" "Yes" (strcat *default-path* "wxls32.ini")))
     (when (> level 1) 
           (msw-write-profile-string 
            "XLisp" "HideMainFrame" "No" (strcat *default-path* "wxls32.ini"))
         ;  (format t "; 2) File and Load Verbose on~%")
           (setf *file-verbose* t) 
           (setf *load-verbose* t)
           (setf *verbosity* 2))
     (when (> level 2) 
         ;  (format t "; 3) Log and all verbose variables on~%")
           (verbose t log)
           (setf *verbosity* 3))
     (when (> level 3)
          ; (format t "; 4) Debug Mode entered~%") 
           (debug-mode t)
           (setf *verbosity* 4))
     (verbose t)))
  (msw-write-profile-string 
   "ViSta" "Verbosity" (format nil "~a" *verbosity*) (strcat *default-path* "wxls32.ini"))
  *verbosity*)



(setf *verbose-file-open* nil)

(defun debug-mode (&optional (logical nil set) &key (verbose nil) (quiet t))
"Args: (&optional (logical nil set) &key (verbose nil) (quiet t))
Sets debug mode and verbosity. Quiet controls output of debug-mode function"
  (let ((b4 *debug-mode*)
        (phrase))
    (when set (setf *debug-mode* (not logical)))
    (debug-toggle)
    (setf phrase (if (equal *debug-mode* b4) "remains" "turned"))
    (unless quiet (format t "; type (debug-mode t :verbose t) for verbose debug~%")
                  (format t "; debug mode ~a ~a~%" phrase (if *debug-mode* "on" "off")))
    (when verbose (format t "; *breakenable* ~a~%" *breakenable*)	
                  (format t "; *tracenable* ~a~%" *tracenable*)
                  (format t "; *tracelimit* ~d~%" *tracelimit*))
    (ini-debug *debug-mode*)
    *debug-mode*))



(defun debug-toggle ()
"Arg: None
Toggles *debug-mode*"
  (cond 
    (*debug-mode*
     (setf *debug-mode* nil)
     (when (and (boundp 'debug-item) debug-item)
          (ignore-errors (send debug-item :mark nil)))
     (setf *debug-mode* nil)
     (setf *breakenable* nil)
     (setf *tracenable* nil)
     )
    (t
     (setf *debug-mode* t) 
     (when (and (boundp 'debug-item) debug-item)
           (ignore-errors (send debug-item :mark t)))
     (setf *debug-mode* t)
     (setf *breakenable* t) 
     (setf *tracenable* t)
     (setf *tracelimit* 3)
     ))
  (when (and (boundp '*hide-xlispstat*)
             (not *hide-xlispstat*)) 
        (clean-up))
  *debug-mode*)
